/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.hwmca.fw.util;

import com.ibm.hwmca.fw.util.TimerQueueEvent;
import com.ibm.hwmca.fw.util.TimerQueueListener;
import com.ibm.hwmca.fw.util.Trace;
import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;

public class TimerQueue
extends Thread {
    private TreeMap events = new TreeMap();
    private Object eventMonitor = new Object();
    private static final String TRACE_MASKT = "XFRMTQ T";
    private static final String TRACE_MASKF = "XFRMTQ F";
    private static final String TRACE_MASKD = "XFRMTQ D";
    private static final boolean DEBUG = false;

    public TimerQueue(String name) {
        Trace.trace(TRACE_MASKT, "<> TimerQueue(" + name + ")");
        this.setName(name);
        this.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void add(long timeout, Object data, TimerQueueListener listener) {
        Trace.trace(TRACE_MASKT, "-> add(timeout=" + timeout + ", data=" + data + ", listener=" + listener + ")");
        Object object = this.eventMonitor;
        synchronized (object) {
            this.events.put(new Long(timeout += new Date().getTime()), new Element(data, listener));
        }
        this.interrupt();
        Trace.trace(TRACE_MASKT, "<- add()");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void remove(Object data) {
        Trace.trace(TRACE_MASKT, "-> remove(data=" + data + ")");
        Object object = this.eventMonitor;
        synchronized (object) {
            Set entries = this.events.entrySet();
            Iterator iterator = entries.iterator();
            while (iterator.hasNext()) {
                Map.Entry entry = iterator.next();
                if (((Element)entry.getValue()).getData() != data) continue;
                iterator.remove();
                this.interrupt();
                break;
            }
        }
        Trace.trace(TRACE_MASKT, "<- remove()");
    }

    public void run() {
        Trace.trace(TRACE_MASKT, "-> run()");
        while (true) {
            try {
                while (true) {
                    TimerQueue.sleep(this.findNextWakeupTime());
                    this.notifyExpiredTasks();
                }
            }
            catch (InterruptedException interruptedException) {
                continue;
            }
            break;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private long findNextWakeupTime() {
        Trace.trace(TRACE_MASKD, "-> findNextWakeupTime()");
        long result = Long.MAX_VALUE;
        Object object = this.eventMonitor;
        synchronized (object) {
            if (!this.events.isEmpty() && (result = (Long)this.events.firstKey() - new Date().getTime()) < 0L) {
                result = 0L;
            }
        }
        Trace.trace(TRACE_MASKD, "<- findNextWakeupTime(returns " + result + ")");
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void notifyExpiredTasks() {
        Trace.trace(TRACE_MASKD, "-> notifyExpiredTasks()");
        ArrayList list = new ArrayList();
        Object object = this.eventMonitor;
        synchronized (object) {
            Map.Entry entry;
            Set entries = this.events.entrySet();
            Iterator iterator = entries.iterator();
            long currentTime = new Date().getTime();
            while (iterator.hasNext() && (Long)(entry = iterator.next()).getKey() <= currentTime) {
                list.add(entry.getValue());
                iterator.remove();
            }
        }
        for (int i = 0; i < list.size(); ++i) {
            Element element = (Element)list.get(i);
            TimerQueueEvent event = new TimerQueueEvent(this, element.getData());
            element.getListener().timerExpired(event);
        }
        Trace.trace(TRACE_MASKD, "<- notifyExpiredTasks()");
    }

    private void dumpQueue() {
    }

    private static class Element {
        private Object data;
        private TimerQueueListener listener;

        public Element(Object data, TimerQueueListener listener) {
            this.data = data;
            this.listener = listener;
        }

        public Object getData() {
            return this.data;
        }

        public TimerQueueListener getListener() {
            return this.listener;
        }

        public String toString() {
            return "data=" + this.getData() + ", listener=" + this.listener;
        }
    }
}

